CREATE DATABASE LigaKreglarskaZmiana
GO

use LigaKreglarskaZmiana
GO

CREATE TABLE Wyniki_kreglarzy (
	IDMeczu int NOT NULL ,
	NumerGry smallint NOT NULL ,
	IDKreglarza int NOT NULL ,
	WynikCzysty smallint NULL ,
	WynikHandicap smallint NULL ,
	GraWygrana bit NOT NULL 
)
GO

CREATE TABLE Wyniki_kreglarzy_archiwum (
	IDMeczu int NOT NULL ,
	NumerGry smallint NOT NULL ,
	IDKreglarza int NOT NULL ,
	WynikCzysty smallint NULL ,
	WynikHandicap smallint NULL ,
	GraWygrana bit NOT NULL 
)
GO

CREATE TABLE Kreglarze (
	IDKreglarza int IDENTITY (1, 1) NOT NULL ,
	NazwiskoKreglarza nvarchar (50) NULL ,
	ImieKreglarza nvarchar (50) NULL ,
	SrodkowyInicjalKreglarza nvarchar (1) NULL ,
	AdresKreglarza nvarchar (50) NULL ,
	MiastoKreglarza nvarchar (50) NULL ,
	StanZamKreglarza nvarchar (2) NULL ,
	KodPocztowyKreglarza nvarchar (10) NULL ,
	TelefonKreglarza nvarchar (14) NULL ,
	IDDruzyny int NULL ,
	LiczbaZbitychKregli int NULL ,
	LiczbaRozegranychGier int NULL ,
	BiezacaSredniaKreglarza smallint NULL ,
	BiezacyHandicapKreglarza smallint NULL 
)
GO

CREATE TABLE Gry_meczowe (
	IDMeczu int NOT NULL ,
	NumerGry smallint NOT NULL ,
	IDWygranejDruzyny smallint NULL 
)
GO

CREATE TABLE Gry_meczowe_archiwum (
	IDMeczu int NOT NULL ,
	NumerGry smallint NOT NULL ,
	IDWygranejDruzyny int NULL 
)
GO

CREATE TABLE Druzyny (
	IDDruzyny int IDENTITY (1, 1) NOT NULL ,
	NazwaDruzyny nvarchar (50) NOT NULL ,
	IDKapitana int NULL 
)
GO

CREATE TABLE Turnieje (
	IDTurnieju int IDENTITY (1, 1) NOT NULL ,
	DataTurnieju date NULL ,
	LokalizacjaTurnieju nvarchar (50) NULL 
)
GO

CREATE TABLE Turnieje_archiwum (
	IDTurnieju int NOT NULL ,
	DataTurnieju date NULL ,
	LokalizacjaTurnieju nvarchar (50) NULL 
)
GO

CREATE TABLE Mecze_turniejowe (
	IDMeczu int IDENTITY (1, 1) NOT NULL ,
	IDTurnieju int NULL ,
	Tory nvarchar (5) NULL ,
	IDDruzynyTorNieparzysty int NULL ,
	IDDruzynyTorParzysty int NULL 
)
GO

CREATE TABLE Mecze_turniejowe_archiwum (
	IDMeczu int NOT NULL ,
	IDTurnieju int NULL ,
	Tory nvarchar (5) NULL ,
	IDDruzynyTorNieparzysty int NULL ,
	IDDruzynyTorParzysty int NULL 
)
GO

CREATE TABLE KodyWaszyngton (
	ZIP nvarchar (5) NOT NULL ,
	City nvarchar (255) NULL ,
	State nvarchar (255) NULL 
)
GO

ALTER TABLE Wyniki_kreglarzy ADD 
	CONSTRAINT WK_ID_meczu_domyslny DEFAULT (0) FOR IDMeczu,
	CONSTRAINT WK_numer_gry_domyslny DEFAULT (0) FOR NumerGry,
	CONSTRAINT WK_ID_kreglarza_domyslny DEFAULT (0) FOR IDKreglarza,
	CONSTRAINT WK_wynik_czysty_domyslny DEFAULT (0) FOR WynikCzysty,
	CONSTRAINT WK_wynik_handicap_domyslny DEFAULT (0) FOR WynikHandicap,
	CONSTRAINT WK_gra_wygrana_domyslny DEFAULT (0) FOR GraWygrana,
	CONSTRAINT Wyniki_kreglarzy_PK PRIMARY KEY   
	(
		IDMeczu,
		NumerGry,
		IDKreglarza
	)   
GO

CREATE  INDEX KreglarzeWynikiKreglarzy ON Wyniki_kreglarzy(IDKreglarza) 
GO

CREATE  INDEX GryMeczoweWynikiKreglarzy ON Wyniki_kreglarzy(IDMeczu, NumerGry) 
GO

ALTER TABLE Wyniki_kreglarzy_archiwum ADD 
	CONSTRAINT WKA_ID_meczu_domyslny DEFAULT (0) FOR IDMeczu,
	CONSTRAINT WKA_numer_gry_domyslny DEFAULT (0) FOR NumerGry,
	CONSTRAINT WKA_IDKreglarza_domyslny DEFAULT (0) FOR IDKreglarza,
	CONSTRAINT WKA_wynik_czysty_domyslny DEFAULT (0) FOR WynikCzysty,
	CONSTRAINT WKA_wynik_handicap_domyslny DEFAULT (0) FOR WynikHandicap,
	CONSTRAINT WKA_gra_wygrana_domyslny DEFAULT (0) FOR GraWygrana,
	CONSTRAINT Wyniki_kreglarzy_archiwum_PK PRIMARY KEY  NONCLUSTERED 
	(
		IDMeczu,
		NumerGry,
		IDKreglarza
	)  
GO

 CREATE  INDEX IDKreglarza ON Wyniki_kreglarzy_archiwum(IDKreglarza)
GO

 CREATE  INDEX Gry_meczowe_archiwumWyniki_kreglarzy_archiwum ON Wyniki_kreglarzy_archiwum(IDMeczu, NumerGry)
GO

ALTER TABLE Kreglarze ADD 
	CONSTRAINT Liczba_zbitych_kregli_domyslny DEFAULT (0) FOR LiczbaZbitychKregli,
	CONSTRAINT Liczba_rozegranych_gier_domyslny DEFAULT (0) FOR LiczbaRozegranychGier,
	CONSTRAINT Biezaca_srednia_kreglarza_domyslny DEFAULT (0) FOR BiezacaSredniaKreglarza,
	CONSTRAINT Biezacy_handicap_kreglarza_domyslny DEFAULT (0) FOR BiezacyHandicapKreglarza,
	CONSTRAINT Kreglarze_PK PRIMARY KEY  
	(
		IDKreglarza
	)  
GO

CREATE  INDEX NazwiskoKreglarza ON Kreglarze(NazwiskoKreglarza) 
GO

CREATE  INDEX KreglarzeIDDruzyny ON Kreglarze(IDDruzyny) 
GO

ALTER TABLE Gry_meczowe ADD 
	CONSTRAINT GM_ID_meczu_domyslny DEFAULT (0) FOR IDMeczu,
	CONSTRAINT GM_numer_gry_domyslny DEFAULT (0) FOR NumerGry,
	CONSTRAINT GM_wygrana_druzyna_domyslny DEFAULT (0) FOR IDWygranejDruzyny,
	CONSTRAINT Gry_meczowe_PK PRIMARY KEY   
	(
		IDMeczu,
		NumerGry
	)   
GO

CREATE  INDEX IDDruzyny1 ON Gry_meczowe(IDWygranejDruzyny) 
GO

CREATE  INDEX MeczeTurniejoweGryMeczowe ON Gry_meczowe(IDMeczu) 
GO

ALTER TABLE Gry_meczowe_archiwum ADD 
	CONSTRAINT GMA_ID_meczu_domyslny DEFAULT (0) FOR IDMeczu,
	CONSTRAINT GMA_numer_gry_domyslny DEFAULT (0) FOR NumerGry,
	CONSTRAINT GMA_ID_wygranej_druzyny_domyslny DEFAULT (0) FOR IDWygranejDruzyny,
	CONSTRAINT Gry_meczowe_archiwum_PK PRIMARY KEY  NONCLUSTERED 
	(
		IDMeczu,
		NumerGry
	)  
GO

 CREATE  INDEX IDDruzyny1 ON Gry_meczowe_archiwum(IDWygranejDruzyny)
GO

 CREATE  INDEX Mecze_turniejowe_archiwumGry_meczowe_archiwum ON Gry_meczowe_archiwum(IDMeczu)
GO

ALTER TABLE Druzyny ADD 
	CONSTRAINT Druzyny_PK PRIMARY KEY   
	(
		IDDruzyny
	)   
GO

ALTER TABLE Turnieje ADD 
	CONSTRAINT Turnieje_PK PRIMARY KEY   
	(
		IDTurnieju
	)   
GO

ALTER TABLE Turnieje_archiwum ADD 
	CONSTRAINT TA_ID_turnieju_domyslny DEFAULT (0) FOR IDTurnieju,
	CONSTRAINT Turnieje_archiwum_PK PRIMARY KEY  NONCLUSTERED 
	(
		IDTurnieju
	)  
GO

ALTER TABLE Mecze_turniejowe ADD 
	CONSTRAINT MT_ID_turnieju_domyslny DEFAULT (0) FOR IDTurnieju,
	CONSTRAINT MT_druzyna_tor_nieparzysty_domyslny DEFAULT (0) FOR IDDruzynyTorNieparzysty,
	CONSTRAINT MT_druzyna_tor_parzysty_domyslny DEFAULT (0) FOR IDDruzynyTorParzysty,
	CONSTRAINT Mecze_turniejowe_PK PRIMARY KEY   
	(
		IDMeczu
	)   
GO

CREATE  INDEX DruzynyMecze_turniejowe_parzysty ON Mecze_turniejowe(IDDruzynyTorParzysty) 
GO

CREATE  INDEX DruzynyMecze_turniejowe_nieparzysty ON Mecze_turniejowe(IDDruzynyTorNieparzysty) 
GO

CREATE  INDEX IDTurnieju ON Mecze_turniejowe(IDTurnieju) 
GO

ALTER TABLE Mecze_turniejowe_archiwum ADD 
	CONSTRAINT MTA_ID_meczu_domyslny DEFAULT (0) FOR IDMeczu,
	CONSTRAINT MTA_ID_turnieju_domyslny DEFAULT (0) FOR IDTurnieju,
	CONSTRAINT MTA_druzyna_tor_nieparzysty_domyslny DEFAULT (0) FOR IDDruzynyTorNieparzysty,
	CONSTRAINT MTA_druzyna_tor_parzysty_domyslny DEFAULT (0) FOR IDDruzynyTorParzysty,
	CONSTRAINT Mecze_turniejowe_archiwum_PK PRIMARY KEY   
	(
		IDMeczu
	)  
GO

 CREATE  INDEX IDDruzyny1 ON Mecze_turniejowe_archiwum(IDDruzynyTorNieparzysty)
GO

 CREATE  INDEX IDDruzyny2 ON Mecze_turniejowe_archiwum(IDDruzynyTorParzysty)
GO

CREATE  INDEX IDTurnieju ON Mecze_turniejowe_archiwum(IDTurnieju)
GO

ALTER TABLE KodyWaszyngton ADD 
	CONSTRAINT KodyWaszyngton_PK PRIMARY KEY   
	(
		ZIP
	)  
GO

ALTER TABLE Wyniki_kreglarzy ADD 
	CONSTRAINT Wyniki_kreglarzy_FK00 FOREIGN KEY 
	(
		IDKreglarza
	) REFERENCES Kreglarze (
		IDKreglarza
	),
	CONSTRAINT Wyniki_kreglarzy_FK01 FOREIGN KEY 
	(
		IDMeczu,
		NumerGry
	) REFERENCES Gry_meczowe (
		IDMeczu,
		NumerGry
	)
GO

ALTER TABLE Wyniki_kreglarzy_archiwum ADD 
	CONSTRAINT Wyniki_kreglarzy_archiwum_FK00 FOREIGN KEY 
	(
		IDMeczu,
		NumerGry
	) REFERENCES Gry_meczowe_archiwum (
		IDMeczu,
		NumerGry
	)
GO

ALTER TABLE Kreglarze ADD 
	CONSTRAINT Kreglarze_FK00 FOREIGN KEY 
	(
		IDDruzyny
	) REFERENCES Druzyny (
		IDDruzyny
	)
GO

ALTER TABLE Gry_meczowe ADD 
	CONSTRAINT Gry_meczowe_FK00 FOREIGN KEY 
	(
		IDMeczu
	) REFERENCES Mecze_turniejowe (
		IDMeczu
	)
GO

ALTER TABLE Gry_meczowe_archiwum ADD 
	CONSTRAINT Gry_meczowe_archiwum_FK00 FOREIGN KEY 
	(
		IDMeczu
	) REFERENCES Mecze_turniejowe_archiwum (
		IDMeczu
	)
GO

ALTER TABLE Mecze_turniejowe ADD 
	CONSTRAINT Mecze_turniejowe_FK00 FOREIGN KEY 
	(
		IDDruzynyTorParzysty
	) REFERENCES Druzyny (
		IDDruzyny
	),
	CONSTRAINT Mecze_turniejowe_FK01 FOREIGN KEY 
	(
		IDDruzynyTorNieparzysty
	) REFERENCES Druzyny (
		IDDruzyny
	),
	CONSTRAINT Mecze_turniejowe_FK02 FOREIGN KEY 
	(
		IDTurnieju
	) REFERENCES Turnieje (
		IDTurnieju
	)
GO

ALTER TABLE Mecze_turniejowe_archiwum ADD 
	CONSTRAINT Mecze_turniejowe_archiwum_FK00 FOREIGN KEY 
	(
		IDTurnieju
	) REFERENCES Turnieje_archiwum (
		IDTurnieju
	)
GO


